/**************************************************************************************
Copyright (c) Hilscher Gesellschaft fuer Systemautomation mbH. All Rights Reserved.
***************************************************************************************
$Id: ProfibusDl_diag.h 50833 2015-01-15 12:54:37Z mark $

Description:
  definition of Profibus DL Task Diagnostic
**************************************************************************************/

#ifndef __PROFIBUS_DL_DIAG_H
#define __PROFIBUS_DL_DIAG_H
/////////////////////////////////////////////////////////////////////////////////////
// PROFIBUS DL Diagnostic Status codes
/////////////////////////////////////////////////////////////////////////////////////
//
// MessageId: TLR_DIAG_E_PROFIBUS_DL_DATA_ACK_RES
//
// MessageText:
//
//  Invalid "Data Ack (SDA)" response packet received. Response does not match to internally reserved communication block
//
#define TLR_DIAG_E_PROFIBUS_DL_DATA_ACK_RES ((TLR_RESULT)0xC0060001L)

//
// MessageId: TLR_DIAG_E_PROFIBUS_DL_DATA_RES
//
// MessageText:
//
//  Invalid "Data (SDN)" response packet received. Response does not match to internally reserved communication block
//
#define TLR_DIAG_E_PROFIBUS_DL_DATA_RES  ((TLR_RESULT)0xC0060002L)

//
// MessageId: TLR_DIAG_E_PROFIBUS_DL_DATA_REPLY_RES
//
// MessageText:
//
//  Invalid "Data Reply (SRD)" response packet received. Response does not match to internally reserved communication block
//
#define TLR_DIAG_E_PROFIBUS_DL_DATA_REPLY_RES ((TLR_RESULT)0xC0060003L)




#endif  //__PROFIBUS_DL_DIAG_H

